# Repository Guidelines

## Project Structure & Module Organization

- `objdiff-core`: core library with diffing logic and shared components
- `objdiff-cli`: CLI/TUI with `ratatui`
- `objdiff-gui`: GUI with `eframe`/`egui`
- `objdiff-wasm`: WebAssembly bindings

objdiff has three main frontends: GUI, CLI/TUI, and [web](https://github.com/encounter/objdiff-web) (utilizing `objdiff-wasm`).

`objdiff-gui` is the most fully-featured and is the primary target for new features.

`objdiff-cli` has an interactive TUI `diff` mode (powered by `ratatui`) and a non-interactive `report` mode to generate detailed progress reports (e.g. for <https://decomp.dev>).

`objdiff-wasm` is compiled into a [WebAssembly Component](https://component-model.bytecodealliance.org/). The [API](objdiff-wasm/wit/objdiff.wit) is defined using [WIT](https://component-model.bytecodealliance.org/design/wit.html). The web interface is separate, but mirrors the GUI in functionality.

## Build, Test, and Development Commands

Run `cargo build` for a debug build and `cargo build --release` for an optimized build.
The CLI can be exercised with `cargo run --release --bin objdiff-cli -- --help`.

The WASM build is not included in the workspace by default due to differences in toolchain and target; build it with `npm -C objdiff-wasm run build`. (nightly required)
In general, do NOT use `--workspace`, as it will include the WASM crate and likely fail. Formatting and linting commands are exempt.

Pre-commit tasks:

- `cargo test` to run the test suite
- `cargo +nightly fmt --all` to format code (nightly required)
- `cargo +nightly clippy --all-targets --all-features --workspace -- -D warnings` to lint code (nightly required)
- `cargo deny check` (`cargo install --locked cargo-deny` if needed) if dependencies change

## Testing Guidelines

Favor focused unit tests adjacent to the code, and integration scenarios in `objdiff-core/tests`.
Integration tests utilize snapshots with the `insta` crate; run `curl -LsSf https://insta.rs/install.sh | sh` if needed.
To generate updated snapshots, use `cargo insta test`, review diffs manually, then accept changes with `cargo insta accept` (or simply `mv` to accept specific snapshots).

## Configuration Tips

- `config.schema.json`: JSON schema for the user-facing project config file (`objdiff.json`)
- `objdiff-core/config-schema.json`: Internal options schema to generate `DiffObjConfig` (see `objdiff-core/config_gen.rs`)

The project configuration (`objdiff.json`) is intended to be generated by the projects' build system. It includes paths to the target (expected) and base (current) object files, along with build commands and file watch patterns. See `README.md` for a summary of key options.
