/** @license React v0.0.0-experimental-7b346e4e5
 * react-fetch.browser.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

if (process.env.NODE_ENV !== "production") {
  (function() {
'use strict';

var unstableCache = require('react/unstable-cache');

var Pending = 0;
var Resolved = 1;
var Rejected = 2;
// TODO: this is a browser-only version. Add a separate Node entry point.
var nativeFetch = window.fetch;
var fetchKey = {};

function readResultMap() {
  var resources = unstableCache.readCache().resources;
  var map = resources.get(fetchKey);

  if (map === undefined) {
    map = new Map();
    resources.set(fetchKey, map);
  }

  return map;
}

function toResult(thenable) {
  var result = {
    status: Pending,
    value: thenable
  };
  thenable.then(function (value) {
    if (result.status === Pending) {
      var resolvedResult = result;
      resolvedResult.status = Resolved;
      resolvedResult.value = value;
    }
  }, function (err) {
    if (result.status === Pending) {
      var rejectedResult = result;
      rejectedResult.status = Rejected;
      rejectedResult.value = err;
    }
  });
  return result;
}

function readResult(result) {
  if (result.status === Resolved) {
    return result.value;
  } else {
    throw result.value;
  }
}

function Response(nativeResponse) {
  this.headers = nativeResponse.headers;
  this.ok = nativeResponse.ok;
  this.redirected = nativeResponse.redirected;
  this.status = nativeResponse.status;
  this.statusText = nativeResponse.statusText;
  this.type = nativeResponse.type;
  this.url = nativeResponse.url;
  this._response = nativeResponse;
  this._arrayBuffer = null;
  this._blob = null;
  this._json = null;
  this._text = null;
}

Response.prototype = {
  constructor: Response,
  arrayBuffer: function () {
    return readResult(this._arrayBuffer || (this._arrayBuffer = toResult(this._response.arrayBuffer())));
  },
  blob: function () {
    return readResult(this._blob || (this._blob = toResult(this._response.blob())));
  },
  json: function () {
    return readResult(this._json || (this._json = toResult(this._response.json())));
  },
  text: function () {
    return readResult(this._text || (this._text = toResult(this._response.text())));
  }
};

function preloadResult(url, options) {
  var map = readResultMap();
  var entry = map.get(url);

  if (!entry) {
    if (options) {
      if (options.method || options.body || options.signal) {
        // TODO: wire up our own cancellation mechanism.
        // TODO: figure out what to do with POST.
        throw Error('Unsupported option');
      }
    }

    var thenable = nativeFetch(url, options);
    entry = toResult(thenable);
    map.set(url, entry);
  }

  return entry;
}

function preload(url, options) {
  preloadResult(url, options); // Don't return anything.
}
function fetch(url, options) {
  var result = preloadResult(url, options);
  var nativeResponse = readResult(result);

  if (nativeResponse._reactResponse) {
    return nativeResponse._reactResponse;
  } else {
    return nativeResponse._reactResponse = new Response(nativeResponse);
  }
}

exports.fetch = fetch;
exports.preload = preload;
  })();
}
