/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.ControllerPlug;
import controlP5.Label;
import controlP5.Toggle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import processing.core.PImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBox
extends ControlGroup<CheckBox> {
    private Object _myPlug;
    private String _myPlugName;
    protected List<Toggle> _myRadioToggles;
    protected int spacingRow = 1;
    protected int spacingColumn = 1;
    protected int itemsPerRow = -1;
    protected boolean isMultipleChoice;
    protected int itemHeight = 9;
    protected int itemWidth = 9;
    protected boolean[] availableImages = new boolean[3];
    protected PImage[] images = new PImage[3];
    protected boolean noneSelectedAllowed = true;

    public CheckBox(ControlP5 controlP5, String string) {
        this(controlP5, (ControllerGroup<?>)controlP5.getDefaultTab(), string, 0, 0);
        controlP5.register(controlP5.papplet, string, this);
    }

    public CheckBox(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, int n, int n2) {
        super(controlP5, controllerGroup, string, n, n2, 99, 9);
        this.isBarVisible = false;
        this.isCollapse = false;
        this._myRadioToggles = new ArrayList<Toggle>();
        this.setItemsPerRow(1);
        this.isMultipleChoice = true;
        this._myPlug = this.cp5.papplet;
        this._myPlugName = this.getName();
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{float[].class})) {
            this._myPlug = null;
        }
    }

    public final CheckBox activateAll() {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            this._myRadioToggles.get(i).activate();
        }
        this.updateValues();
        return this;
    }

    public final CheckBox activate(int n) {
        if (n < this._myRadioToggles.size()) {
            this._myRadioToggles.get(n).activate();
            this.updateValues();
        }
        return this;
    }

    public final CheckBox deactivate(int n) {
        if (n < this._myRadioToggles.size()) {
            this._myRadioToggles.get(n).deactivate();
            this.updateValues();
        }
        return this;
    }

    public final CheckBox toggle(int n) {
        if (n < this._myRadioToggles.size()) {
            Toggle toggle = this._myRadioToggles.get(n);
            if (toggle.getState()) {
                toggle.deactivate();
            } else {
                toggle.activate();
            }
            this.updateValues();
        }
        return this;
    }

    public final void toggle(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle toggle = this._myRadioToggles.get(i);
            if (!string.equals(toggle.getName())) continue;
            if (toggle.getState()) {
                toggle.deactivate();
            } else {
                toggle.activate();
            }
            this.updateValues();
            return;
        }
    }

    public final CheckBox activate(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle toggle = this._myRadioToggles.get(i);
            if (!string.equals(toggle.getName())) continue;
            toggle.activate();
            this.updateValues();
            return this;
        }
        return this;
    }

    public final CheckBox deactivate(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle toggle = this._myRadioToggles.get(i);
            if (!string.equals(toggle.getName())) continue;
            toggle.deactivate();
            this.updateValues();
            return this;
        }
        return this;
    }

    private final void updateValues() {
        this._myValue = -1.0f;
        this.updateValues(true);
    }

    @Override
    public CheckBox setArrayValue(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            if (this._myArrayValue[i] == fArray[i]) continue;
            if (fArray[i] == 0.0f) {
                this._myRadioToggles.get(i).deactivate();
                continue;
            }
            this._myRadioToggles.get(i).activate();
        }
        super.setArrayValue(fArray);
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tCheckBox\n" + super.getInfo();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public CheckBox addItem(String string, float f) {
        Toggle toggle = this.cp5.addToggle(string, 0.0f, 0.0f, this.itemWidth, this.itemHeight);
        toggle.getCaptionLabel().align(11, 3).setPadding(Label.paddingX, 0);
        toggle.setMode(0);
        toggle.setImages(this.images[0], this.images[1], this.images[2]);
        toggle.setSize(this.images[0]);
        this.addItem(toggle, f);
        return this;
    }

    public CheckBox addItem(Toggle toggle, float f) {
        toggle.setGroup(this);
        toggle.isMoveable = false;
        toggle.setInternalValue(f);
        toggle.isBroadcast = false;
        this._myRadioToggles.add(toggle);
        this.updateLayout();
        this.getColor().copyTo(toggle);
        toggle.addListener(this);
        this.updateValues(false);
        this.cp5.removeProperty(toggle);
        return this;
    }

    public CheckBox removeItem(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            if (!this._myRadioToggles.get(i).getName().equals(string)) continue;
            this._myRadioToggles.get(i).removeListener(this);
            this._myRadioToggles.remove(i);
        }
        this.updateValues(false);
        return this;
    }

    public CheckBox setImages(PImage pImage, PImage pImage2, PImage pImage3) {
        this.setImage(pImage, 0);
        this.setImage(pImage2, 1);
        this.setImage(pImage3, 2);
        return this;
    }

    public CheckBox setImage(PImage pImage) {
        return this.setImage(pImage, 0);
    }

    public CheckBox setImage(PImage pImage, int n) {
        if (pImage != null) {
            this.images[n] = pImage;
            this.availableImages[n] = true;
            for (int i = 0; i < this._myRadioToggles.size(); ++i) {
                this._myRadioToggles.get(i).setImage(pImage, n);
            }
        }
        return this;
    }

    public CheckBox setSize(PImage pImage) {
        return this.setSize(pImage.width, pImage.height);
    }

    @Override
    public CheckBox setSize(int n, int n2) {
        this.setItemWidth(n);
        this.setItemHeight(n2);
        return this;
    }

    public CheckBox setItemHeight(int n) {
        this.itemHeight = n;
        for (Toggle toggle : this._myRadioToggles) {
            toggle.setHeight(n);
        }
        this.updateLayout();
        return this;
    }

    public CheckBox setItemWidth(int n) {
        this.itemWidth = n;
        for (Toggle toggle : this._myRadioToggles) {
            toggle.setWidth(n);
        }
        this.updateLayout();
        return this;
    }

    public Toggle getItem(int n) {
        return this._myRadioToggles.get(n);
    }

    public List<Toggle> getItems() {
        return this._myRadioToggles;
    }

    public boolean getState(int n) {
        if (n < this._myRadioToggles.size() && n >= 0) {
            return this._myRadioToggles.get(n).getState();
        }
        return false;
    }

    public boolean getState(String string) {
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            Toggle toggle = this._myRadioToggles.get(i);
            if (!string.equals(toggle.getName())) continue;
            return toggle.getState();
        }
        return false;
    }

    public void updateLayout() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this._myRadioToggles.size();
        for (int i = 0; i < n4; ++i) {
            Toggle toggle = this._myRadioToggles.get(i);
            toggle.position.y = n3;
            toggle.position.x = n2;
            n2 += toggle.width + this.spacingColumn;
            if (++n == this.itemsPerRow) {
                n = 0;
                this._myWidth = n2;
                n3 += toggle.height + this.spacingRow;
                n2 = 0;
                continue;
            }
            this._myWidth = n2;
        }
    }

    public CheckBox setItemsPerRow(int n) {
        this.itemsPerRow = n;
        this.updateLayout();
        return this;
    }

    public CheckBox setSpacingColumn(int n) {
        this.spacingColumn = n;
        this.updateLayout();
        return this;
    }

    public CheckBox setSpacingRow(int n) {
        this.spacingRow = n;
        this.updateLayout();
        return this;
    }

    public CheckBox deactivateAll() {
        if (!this.isMultipleChoice && !this.noneSelectedAllowed) {
            return this;
        }
        int n = this._myRadioToggles.size();
        for (int i = 0; i < n; ++i) {
            this._myRadioToggles.get(i).deactivate();
        }
        this._myValue = -1.0f;
        this.updateValues(true);
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void controlEvent(ControlEvent controlEvent) {
        if (!this.isMultipleChoice) {
            if (!this.noneSelectedAllowed && controlEvent.getController().getValue() < 1.0f && controlEvent.getController() instanceof Toggle) {
                Toggle toggle = (Toggle)controlEvent.getController();
                boolean bl = toggle.isBroadcast();
                toggle.setBroadcast(false);
                toggle.setState(true);
                toggle.setBroadcast(bl);
                return;
            }
            this._myValue = -1.0f;
            int n = this._myRadioToggles.size();
            for (int i = 0; i < n; ++i) {
                Toggle toggle = this._myRadioToggles.get(i);
                if (!toggle.equals(controlEvent.getController())) {
                    toggle.deactivate();
                    continue;
                }
                if (!toggle.isOn) continue;
                this._myValue = toggle.internalValue();
            }
        }
        this.updateValues(true);
        if (this._myPlug != null) {
            try {
                Method method = this._myPlug.getClass().getMethod(this._myPlugName, float[].class);
                method.invoke(this._myPlug, new Object[]{this.getArrayValue()});
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public CheckBox plugTo(Object object) {
        this._myPlug = object;
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{float[].class})) {
            this._myPlug = null;
        }
        return this;
    }

    public CheckBox plugTo(Object object, String string) {
        this._myPlug = object;
        this._myPlugName = string;
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{float[].class})) {
            this._myPlug = null;
        }
        return this;
    }

    protected void updateValues(boolean bl) {
        int n = this._myRadioToggles.size();
        this._myArrayValue = new float[n];
        for (int i = 0; i < n; ++i) {
            Toggle toggle = this._myRadioToggles.get(i);
            this._myArrayValue[i] = toggle.getValue();
        }
        if (bl) {
            ControlEvent controlEvent = new ControlEvent(this);
            this.cp5.getControlBroadcaster().broadcast(controlEvent, 2);
        }
    }

    public CheckBox setNoneSelectedAllowed(boolean bl) {
        this.noneSelectedAllowed = bl;
        return this;
    }

    public CheckBox setColorLabels(int n) {
        for (Toggle toggle : this._myRadioToggles) {
            toggle.getCaptionLabel().setColor(n);
        }
        return this;
    }

    public CheckBox hideLabels() {
        for (Toggle toggle : this._myRadioToggles) {
            toggle.getCaptionLabel().setVisible(false);
        }
        return this;
    }

    public CheckBox showLabels() {
        for (Toggle toggle : this._myRadioToggles) {
            toggle.getCaptionLabel().setVisible(true);
        }
        return this;
    }

    public CheckBox toUpperCase(boolean bl) {
        for (Toggle toggle : this._myRadioToggles) {
            toggle.getCaptionLabel().toUpperCase(bl);
        }
        return this;
    }

    @Deprecated
    public CheckBox add(String string, float f) {
        return this.addItem(string, f);
    }
}

