/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControllerInterface;
import controlP5.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Accordion
extends ControlGroup<Accordion> {
    protected int spacing = 1;
    protected int minHeight = 100;
    protected int itemheight;
    protected int _myMode = 0;

    public Accordion(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0, 0, 200);
        controlP5.register(controlP5.papplet, string, this);
    }

    Accordion(ControlP5 controlP5, Tab tab, String string, int n, int n2, int n3) {
        super(controlP5, tab, string, n, n2, n3, 9);
        this.hideBar();
    }

    public Accordion addItem(ControlGroup<?> controlGroup) {
        controlGroup.close();
        controlGroup.moveTo(this);
        controlGroup.activateEvent(true);
        controlGroup.addListener(this);
        controlGroup.setMoveable(false);
        if (controlGroup.getBackgroundHeight() < this.minHeight) {
            controlGroup.setBackgroundHeight(this.minHeight);
        }
        this.controllers.add(controlGroup);
        this.updateItems();
        return this;
    }

    @Override
    public Accordion remove(ControllerInterface<?> controllerInterface) {
        if (controllerInterface instanceof ControlGroup) {
            this.controllers.remove(controllerInterface);
            ((ControlGroup)controllerInterface).removeListener(this);
            this.updateItems();
        }
        super.remove(controllerInterface);
        return this;
    }

    public Accordion removeItem(ControlGroup<?> controlGroup) {
        if (controlGroup == null) {
            return this;
        }
        this.controllers.remove(controlGroup);
        controlGroup.removeListener(this);
        controlGroup.moveTo(this.cp5.controlWindow);
        this.updateItems();
        return this;
    }

    public Accordion updateItems() {
        int n = 0;
        this.setWidth(this._myWidth);
        for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
            if (!(controllerInterface instanceof ControlGroup)) continue;
            controllerInterface.setPosition(0.0f, n += ((ControlGroup)controllerInterface).getBarHeight() + this.spacing);
            if (!((ControlGroup)controllerInterface).isOpen()) continue;
            n += ((ControlGroup)controllerInterface).getBackgroundHeight();
        }
        return this;
    }

    public Accordion setMinItemHeight(int n) {
        this.minHeight = n;
        for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
            if (!(controllerInterface instanceof ControlGroup) || ((ControlGroup)controllerInterface).getBackgroundHeight() >= this.minHeight) continue;
            ((ControlGroup)controllerInterface).setBackgroundHeight(this.minHeight);
        }
        this.updateItems();
        return this;
    }

    public int getMinItemHeight() {
        return this.minHeight;
    }

    public Accordion setItemHeight(int n) {
        this.itemheight = n;
        for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
            if (!(controllerInterface instanceof ControlGroup)) continue;
            ((ControlGroup)controllerInterface).setBackgroundHeight(this.itemheight);
        }
        this.updateItems();
        return this;
    }

    public int getItemHeight() {
        return this.itemheight;
    }

    @Override
    public Accordion setWidth(int n) {
        super.setWidth(n);
        for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
            if (!(controllerInterface instanceof ControlGroup)) continue;
            ((ControlGroup)controllerInterface).setWidth(n);
        }
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.isGroup()) {
            int n = 0;
            for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
                if (!(controllerInterface instanceof ControlGroup)) continue;
                controllerInterface.setPosition(0.0f, n += ((ControlGroup)controllerInterface).getBarHeight() + this.spacing);
                if (this._myMode == 0) {
                    if (controllerInterface == controlEvent.getGroup() && ((ControlGroup)controllerInterface).isOpen()) {
                        n += ((ControlGroup)controllerInterface).getBackgroundHeight();
                        continue;
                    }
                    ((ControlGroup)controllerInterface).close();
                    continue;
                }
                if (!((ControlGroup)controllerInterface).isOpen()) continue;
                n += ((ControlGroup)controllerInterface).getBackgroundHeight();
            }
        }
    }

    @Override
    public Accordion open() {
        int[] nArray = new int[this.controllers.size()];
        for (int i = 0; i < this.controllers.size(); ++i) {
            nArray[i] = i;
        }
        return this.open(nArray);
    }

    @Override
    public Accordion close() {
        int[] nArray = new int[this.controllers.size()];
        for (int i = 0; i < this.controllers.size(); ++i) {
            nArray[i] = i;
        }
        return this.close(nArray);
    }

    public Accordion open(int ... nArray) {
        if (nArray[0] == -1) {
            return this.open();
        }
        int n = 0;
        int n2 = 0;
        for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
            int n3;
            if (!(controllerInterface instanceof ControlGroup)) continue;
            boolean bl = false;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] != n2) continue;
                bl = true;
            }
            n3 = ((ControlGroup)controllerInterface).isOpen() || bl ? 1 : 0;
            ++n2;
            controllerInterface.setPosition(0.0f, n += ((ControlGroup)controllerInterface).getBarHeight() + this.spacing);
            if (n3 == 0) continue;
            n += ((ControlGroup)controllerInterface).getBackgroundHeight();
            ((ControlGroup)controllerInterface).open();
        }
        return this;
    }

    public Accordion close(int ... nArray) {
        if (nArray[0] == -1) {
            return this.close();
        }
        int n = 0;
        int n2 = 0;
        for (ControllerInterface<?> controllerInterface : this.controllers.get()) {
            int n3;
            if (!(controllerInterface instanceof ControlGroup)) continue;
            boolean bl = false;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] != n2) continue;
                bl = true;
            }
            n3 = !((ControlGroup)controllerInterface).isOpen() || bl ? 1 : 0;
            ++n2;
            ((ControlGroup)controllerInterface).setPosition(0.0f, n += ((ControlGroup)controllerInterface).getBarHeight() + this.spacing);
            if (n3 != 0) {
                ((ControlGroup)controllerInterface).close();
                continue;
            }
            n += ((ControlGroup)controllerInterface).getBackgroundHeight();
        }
        return this;
    }

    public Accordion setCollapseMode(int n) {
        this._myMode = n == 0 ? 0 : 1;
        return this;
    }
}

