---
id: text
title: Text
---

import useBaseUrl from '@docusaurus/useBaseUrl';

Text displays words and characters at various sizes.

<img alt="Text" src={useBaseUrl('img/text.png')} />

## Usage

```js
import { Text } from 'react-native-elements';

<Text h1>Heading 1</Text>
<Text h2>Heading 2</Text>
<Text h3>Heading 3</Text>
<Text h4>Heading 4</Text>
```

---

## Props

- [`h1`](#h1)
- [`h1Style`](#h1style)
- [`h2`](#h2)
- [`h2Style`](#h2style)
- [`h3`](#h3)
- [`h3Style`](#h3style)
- [`h4`](#h4)
- [`h4Style`](#h4style)
- [`style`](#style)

---

## Reference

### `h1`

font size 40 (optional)

|  Type   | Default |
| :-----: | :-----: |
| boolean |  none   |

---

### `h1Style`

Styling for when `h1` is set (optional)

|        Type         | Default |
| :-----------------: | :-----: |
| Text style (object) |  none   |

---

### `h2`

font size 34 (optional)

|  Type   | Default |
| :-----: | :-----: |
| boolean |  none   |

---

### `h2Style`

Styling for when `h2` is set (optional)

|        Type         | Default |
| :-----------------: | :-----: |
| Text style (object) |  none   |

---

### `h3`

font size 28 (optional)

|  Type   | Default |
| :-----: | :-----: |
| boolean |  none   |

---

### `h3Style`

Styling for when `h3` is set (optional)

|        Type         | Default |
| :-----------------: | :-----: |
| Text style (object) |  none   |

---

### `h4`

font size 22 (optional)

|  Type   | Default |
| :-----: | :-----: |
| boolean |  none   |

---

### `h4Style`

Styling for when `h4` is set (optional)

|        Type         | Default |
| :-----------------: | :-----: |
| Text style (object) |  none   |

---

### `style`

add additional styling for Text (optional)

|        Type         | Default |
| :-----------------: | :-----: |
| Text style (object) |  none   |
