# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/), and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## 0.47.0 (2025-11-27)

## What's Changed
* feat: update webui to v4.10.0 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/3015
* feat: electron 39 + kubo 0.39 with sweep and fast root cid provides by @lidel in https://github.com/ipfs/ipfs-desktop/pull/3020


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.46.2...v0.47.0

## 0.46.2 (2025-10-31)

## What's Changed
* fix(windows): update publisher name by @lidel in https://github.com/ipfs/ipfs-desktop/pull/3013


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.46.1...v0.46.2

## 0.46.1 (2025-10-30)

## What's Changed
* fix: kubo 0.38.2 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/3011


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.46.0...v0.46.1

## 0.46.0 (2025-10-08)

## What's Changed
* feat: kubo 0.38 and webui 4.9 and electron 38 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2995
* fix: kubo v0.38.1 with Windows migrations by @lidel in https://github.com/ipfs/ipfs-desktop/pull/3003


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.45.0...v0.46.0

## 0.45.0 (2025-08-27)

## What's Changed
* feat: ipfs-webui v4.8.0 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2981
* chore(readme): fix correct broken CI link by @alikhere in https://github.com/ipfs/ipfs-desktop/pull/2986
* feat: kubo 0.37 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2988

## New Contributors
* @alikhere made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2986

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.44.0...v0.45.0

## 0.44.0 (2025-07-14)

## What's Changed
* feat: kubo 0.36 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2963


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.43.0...v0.44.0

## 0.43.0 (2025-05-22)

## What's Changed
* feat: ipfs-webui v4.7 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2942
* ci: uci/copy-templates by @web3-bot in https://github.com/ipfs/ipfs-desktop/pull/2946
* feat: kubo v0.35, electron 36 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2949
* chore: sync translations by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2951
* fix(linux): electron 35 to fix GTK error by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2953

## New Contributors
* @web3-bot made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2946

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.42.0...v0.43.0

## 0.42.0 (2025-03-27)

## What's Changed
* feat: kubo 0.34 + electron 35 + windows signing by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2936
* feat: ipfs-webui v4.6 with CAR import by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2938


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.41.2...v0.42.0

## 0.41.2 (2025-02-14)

## What's Changed
* fix: kubo 0.33.2 + electron 34.2 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2930


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.41.1...v0.41.2

## 0.41.1 (2025-02-05)

## What's Changed
* fix: kubo 0.33.1 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2921
* chore(deps): bump dsaltares/fetch-gh-release-asset from 1.1.1 to 1.1.2 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2798
* fix: ipfs-webui v4.4.2 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2918


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.41.0...v0.41.1

## 0.41.0 (2025-01-30)

## What's Changed
* fix: ipfs-webui v4.4.1 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2898
* chore: add FUNDING.json by @cewood in https://github.com/ipfs/ipfs-desktop/pull/2914
* fix(ci): ubuntu e2e tests by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2915
* feat: electron 34 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2916
* feat: kubo 0.33 with AutoTLS enabled by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2917

## New Contributors
* @cewood made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2914

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.40.0...v0.41.0

## 0.40.0 (2024-11-20)

## What's Changed
* feat: ipfs-webui v4.4.0 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2886
* refactor: lossless compression of assets by @Awqre in https://github.com/ipfs/ipfs-desktop/pull/2892
* chore: kubo 0.32 + electron 33.2 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2890
* fix(explore): switch back to ipfs-webui v4.3.3 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2893

## New Contributors
* @Awqre made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2892

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.39.0...v0.40.0

## 0.39.0 (2024-10-16)

## What's Changed
* feat: use ipfs-webui@4.3.2 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2861
* feat: ipfs-webui v4.3.3 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2877
* feat: kubo v0.31 and electron v32 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2875


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.38.0...v0.39.0

## 0.38.0 (2024-09-11)

## What's Changed
* feat: webui v4.3.0 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2847
* feat: kubo 0.30.0 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2855


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.37.0...v0.38.0

## 0.37.0 (2024-06-13)

## What's Changed
* feat: electron 31 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2832


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.36.0...v0.37.0

## 0.36.0 (2024-06-12)

## What's Changed
* docs: link to faq on known error by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2827
* feat: kubo 0.29 and native apple silicon by @lidel in https://github.com/ipfs/ipfs-desktop/pull/1856
* docs: add more known soutions by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2829


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.35.1...v0.36.0

## 0.35.1 (2024-05-16)

## What's Changed
* fix: downgrade to macos-13 for intel-compat build by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2811


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.35.0...v0.35.1

## 0.35.0 (2024-05-13)

## What's Changed
* chore: webui v4.2.1 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2789
* Update Kubo: v0.28.0 by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2792
* docs(readme): additional download metrics by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2796


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.34.0...v0.35.0

## 0.34.0 (2024-03-27)

## What's Changed
* chore(deps): bump actions/cache from 3 to 4 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2736
* Update Kubo: v0.27.0 by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2763
* chore: fix typo in README.md by @occupyhabit in https://github.com/ipfs/ipfs-desktop/pull/2771
* chore(deps): bump actions/setup-node from 3 to 4 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2694
* chore(deps): bump actions/upload-artifact from 3 to 4 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2723
* chore(deps): bump snapcore/action-publish from 1.1.1 to 1.2.0 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2693

## New Contributors
* @occupyhabit made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2771

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.33.0...v0.34.0

## 0.33.0 (2024-01-22)

## What's Changed
* deps: webui v4.2.0 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2705
* feat: kubo v0.25.0 by @Jorropo in https://github.com/ipfs/ipfs-desktop/pull/2721
* feat: kubo v0.26.0 by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2737


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.32.0...v0.33.0

## 0.32.0 (2023-11-27)

## What's Changed
* chore: automate releases with release-please by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2664
* chore(main): release 0.31.1 by @github-actions in https://github.com/ipfs/ipfs-desktop/pull/2682
* fix: release-please release creation by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2683
* chore: remove 0.31.1 release testing artifacts by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2684
* chore(deps): bump actions/checkout from 3 to 4 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2620
* feat: kubo 0.24.0 by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2697

## New Contributors
* @github-actions made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2682

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.31.0...v0.32.0

## [v0.30.2] - 2023-08-11

## What's Changed
* chore: typo fixes by @criadoperez in https://github.com/ipfs/ipfs-desktop/pull/2633
* docs(readme): add repo migration FAQ sections by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2634
* Update README.md by @MichaelJCole in https://github.com/ipfs/ipfs-desktop/pull/2642
* fix: i18n init done fires even with lang load error by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2650
* ci: pin node-version to 18.17.1 by @galargh in https://github.com/ipfs/ipfs-desktop/pull/2662
* kubo: update to v0.23.0 by @Jorropo in https://github.com/ipfs/ipfs-desktop/pull/2654
* fix: ipfs-desktop config can disable autoUpdate by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2651

## New Contributors
* @criadoperez made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2633
* @MichaelJCole made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2642

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.30.2...v0.31.0

## [v0.30.2] - 2023-09-13

## What's Changed
* fix: tray translation waits for i18n init by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2604
* fix: ensure menu items update properly by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2605
* deps: webui v4.1.1 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2621
* fix(apple-notarize): use notarytool and teamId by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2624


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.30.1...v0.30.2

## [v0.30.1] - 2023-08-22

## What's Changed
* chore(deps): bump protobufjs from 6.11.3 to 6.11.4 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2583
* refactor: switch npm to kubo by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2590
* fix(tray): :adhesive_bandage: Fixes the context loaded async in the tray. by @whizzzkid in https://github.com/ipfs/ipfs-desktop/pull/2593
* chore(deps-dev): bump semver from 5.7.1 to 5.7.2 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2557
* chore(deps-dev): bump word-wrap from 1.2.3 to 1.2.4 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2556
* fix(tray): :wrench: Fix setter for tray-menu by @whizzzkid in https://github.com/ipfs/ipfs-desktop/pull/2594


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.30.0...v0.30.1

## [v0.30.0] - 2023-08-09

## What's Changed
* fix: add logger to electron-updater by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2552
* Create SECURITY.md by @Silvrbckw in https://github.com/ipfs/ipfs-desktop/pull/2555
* feat: app lazy-loads app-context by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2378
* feat: webui@4.1.0 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2560
* feat: add splash screen on top of ctx refactor by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2548
* feat: catch and log electron-store.set errors by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2547
* chore: bump kubo to 0.22.0 by @Jorropo in https://github.com/ipfs/ipfs-desktop/pull/2569

## New Contributors
* @Silvrbckw made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2555
* @Jorropo made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2569

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.29.0...v0.30.0

## [v0.29.0] - 2023-07-04

## What's Changed
* chore(deps): bump json5 from 1.0.1 to 1.0.2 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2371
* chore(deps): bump minimatch and electron-builder by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2436
* feat: webui@4.0.0 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2510
* chore(deps): bump actions/upload-artifact from 2 to 3 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2516
* chore(deps): bump actions/cache from 2 to 3 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2515
* chore(deps): bump actions/setup-node from 2 to 3 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2514
* chore(deps): bump snapcore/action-publish from 1.0.2 to 1.1.1 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2513
* chore: update github actions by @galargh in https://github.com/ipfs/ipfs-desktop/pull/2520
* chore(deps): bump actions/checkout from 1 to 3 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2523
* feat: webui@4.0.2 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2538
* Update Kubo: v0.21.0 by @galargh in https://github.com/ipfs/ipfs-desktop/pull/2539


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.28.0...v0.29.0

## [v0.28.0] - 2023-05-10

## What's Changed
* Update Kubo: v0.20.0 by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2481

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.27.3...v0.28.0

## [v0.27.3] - 2023-05-10

## What's Changed
* fix: Fix incorrect link for Kubo version in tray icon by @is-this-echo in https://github.com/ipfs/ipfs-desktop/pull/2473
* chore: remove workflows/auto-project.yml by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2477
* Update Kubo: v0.19.2 by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2474

## New Contributors
* @is-this-echo made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2473

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.27.2...v0.27.3

## [v0.27.2] - 2023-03-20

## What's Changed
* Update Kubo: v0.19.1 by @galargh in https://github.com/ipfs/ipfs-desktop/pull/2453
* feat: webui@3.0.0 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2466
* chore(deps-dev): bump semver-regex from 3.1.3 to 3.1.4 by @dependabot in https://github.com/ipfs/ipfs-desktop/pull/2165

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.27.0...v0.27.2

## [v0.27.1] - 2023-03-20

Skipped due to an issue with hanging tag v0.27.0. Points to the commit that v0.27.0 should have.

## [v0.27.0] - 2023-03-20

## What's Changed
* Use CIDv1 by default by @davidd8 in https://github.com/ipfs/ipfs-desktop/pull/2402
* docs: add features doc by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2377
* Update Kubo: v0.19.0 by @galargh in https://github.com/ipfs/ipfs-desktop/pull/2435

## New Contributors
* @davidd8 made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2402

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.26.1...v0.27.0

## [v0.26.1] - 2023-02-10

## What's Changed
* chore(docs): v0.26.0 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2389
* Update Kubo: v0.18.1 by @galargh in https://github.com/ipfs/ipfs-desktop/pull/2396
* Update ci.yml by @galargh in https://github.com/ipfs/ipfs-desktop/pull/2413

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.26.0...v0.26.1

## [v0.26.0] - 2023-01-27

## Important changes in this release

This release includes changing our metrics collection policy to opt-out instead of opt-in. This means app data (non-user data), or telemetry, is gathered by default when running the application. Note that you can still disable the collection of telemetry in the settings page. For more information, see the following:

1. https://github.com/ipfs-shipyard/ignite-metrics/blob/main/docs/telemetry/COLLECTION_POLICY.md
2. https://github.com/ipfs-shipyard/ignite-metrics/pull/76
3. https://github.com/ipfs/ipfs-gui/issues/117

## What's Changed
* feat: kubo 0.18 with /quic-v1 and /webtransport by @galargh in https://github.com/ipfs/ipfs-desktop/pull/2363
* feat: Updating ipfs-webui CID to v2.22.0 by @djmcquillan in https://github.com/ipfs/ipfs-desktop/pull/2387

## New Contributors
* @djmcquillan made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2387

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.25.0...v0.26.0

## [v0.25.0] - 2022-12-11

## What's Changed

* feat: kubo v0.17.0 by @galargh in https://github.com/ipfs/ipfs-desktop/pull/2338
* fix: support `/quic-v1` on Peers page by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2356
* docs(readme): add repology badge by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2352
* chore: release prep by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2344
* chore(readme): 0.24.0 -> 0.24.1 by @whizzzkid in https://github.com/ipfs/ipfs-desktop/pull/2333

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.24.1...v0.25.0


## [v0.24.1] - 2022-11-10

## What's Changed
* Update README.md by @michael-spengler in https://github.com/ipfs/ipfs-desktop/pull/2289
* chore: bump go-ipfs version to 0.16.0 by @galargh in https://github.com/ipfs/ipfs-desktop/pull/2280
* fix: adjust mac and dmg artifactName by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2296
* chore(readme): 0.24.0 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2298
* feat: Updating ipfs-webui CID to v2.20.0 by @whizzzkid in https://github.com/ipfs/ipfs-desktop/pull/2331

## New Contributors
* @michael-spengler made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2289
* @whizzzkid made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2331

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.24.0...v0.24.1


## [v0.24.0] - 2022-10-03

## What's Changed
* feat: monochrome tray icon on Windows & Linux by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2159
* chore(deps): webui v2.18.0 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2263
* feat: Create CODEOWNERS by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2239
* feat: include platform version in error report by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2256
* fix: ensure .Swarm.ConnMgr exists before accessing by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2255
* feat: ipfs-webui v2.18.1 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2267
* refactor: use ipcMainEvents constant  by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2250
* chore: webui@v2.19.0 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2286

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.23.0...v0.24.0


## [v0.23.0] - 2022-08-30

## What's Changed
* chore: i18n, CI, and dep updates by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2214
* fix: quit if repository is part of private network by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2223
* chore(maintenance): remove addedApiPort after go-ipfs 0.13 by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2226
* fix: log correct error on spawn by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2225
* fix: use constants for withAnalytics keys by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2224
* Change 'Go-ipfs' to 'Kubo' in tray menu by @bertrandfalguiere in https://github.com/ipfs/ipfs-desktop/pull/2246
* feat: jsdoc and improvements to daemon logic by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2227
* feat: Kubo 0.15.0 by @ajnavarro in https://github.com/ipfs/ipfs-desktop/pull/2240

## New Contributors
* @bertrandfalguiere made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2246
* @ajnavarro made their first contribution in https://github.com/ipfs/ipfs-desktop/pull/2240

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.22.0...v0.23.0


## [v0.22.0] - 2022-07-21

- IPFS: [`kubo v0.14.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.14.0) :sparkles:
- UI: [`v2.15.1`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.15.1) :sparkles:

* feat: ipfs-webui v2.15.1 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2190
* feat: kubo 0.14 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2210
* docs: update manual QA script by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2176
* docs: add network error troubleshoot by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2178
* chore: remove unused auto-project triggers by @galargh in https://github.com/ipfs/ipfs-desktop/pull/2207
* chore: use official github action in auto-project by @galargh in https://github.com/ipfs/ipfs-desktop/pull/2208
* chore: create enum for ipcMain eventNames by @noliveira95 in https://github.com/ipfs/ipfs-desktop/pull/2189

## [v0.21.0] - 2022-06-13

- IPFS: [`go-ipfs v0.13.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.13.0) :sparkles:
- UI: [`v2.15.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.15.0)

* docs: v0.20.6 by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2137
* Remove hardcoded DHT client routing by @2color in https://github.com/ipfs/ipfs-desktop/pull/2152
* chore: remove deprecated ipfs-on-path, npm-on-ipfs by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2140
* chore(maintenance): move config keys to separate file by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2143
* go-ipfs v0.13.0 by @guseggert in https://github.com/ipfs/ipfs-desktop/pull/2166
* chore: electron build updates by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2172

## [v0.20.6] - 2021-05-12

* fix: return error instead of throw by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2074
* README: Update link that points to ipfs-shipyard repository by @schuelermine in https://github.com/ipfs/ipfs-desktop/pull/2119
* docs: Add repo.lock troubleshooting steps to readme by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2111
* feat: Add app&webui ready/load metrics by @SgtPooki in https://github.com/ipfs/ipfs-desktop/pull/2126


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.20.5...v0.20.6

## [v0.20.5] - 2021-04-09

- IPFS: [`go-ipfs v0.12.2`](https://github.com/ipfs/go-ipfs/releases/tag/v0.12.2)
- UI: [`v2.15.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.15.0)

* chore: electron 18  and go-ipfs 0.12.2 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2098


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.20.4...v0.20.5

## [v0.20.4] - 2021-03-28

- IPFS: [`go-ipfs v0.12.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.12.0)
- UI: [`v2.15.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.15.0)

* fix: migrating to less expensive config in `Swarm.ConnMgr` by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2055
* fix: detect invalid or corrupted repository by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2067
* fix: static message when ipfs daemon dies on start by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2078
* refactor: remove 'download' functionality by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2061
* chore: remove unused and update dependencies by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/2047


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.20.3...v0.20.4

## [v0.20.3] - 2021-03-21

- IPFS: [`go-ipfs v0.12.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.12.0)
- UI: [`v2.15.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.15.0)

* fix: ipfs-companion rpc api in go-ipfs <0.13 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2054


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.20.2...v0.20.3

## [v0.20.2] - 2021-03-15

- IPFS: [`go-ipfs v0.12.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.12.0)
- UI: [`v2.15.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.15.0)

* docs: 0.20.x by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2012
* fix: ux of notification after file import by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2013
* refactor: remove checkCorsConfig  by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/1955
* docs: debian 11 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2033
* feat: add known webui addresses to CORS conf by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/1956
* fix: pass ipfs config show error by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2032
* fix: proper catch-all daemon startup errors by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2030


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.20.1...v0.20.2

## [v0.20.1] - 2021-03-07

- IPFS: [`go-ipfs v0.12.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.12.0)
- UI: [`v2.15.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.15.0)

* fix: migration fallback to ipfs by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2008
* refactor: remove mocha/chai, fix e2e on windows by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2007
* fix: increase free port lookup range by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2010
* fix: gui error report title by @lidel in https://github.com/ipfs/ipfs-desktop/pull/2011


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.20.0...v0.20.1

## [v0.20.0] - 2021-03-01

- IPFS: [`go-ipfs v0.12.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.12.0) ✨
- UI: [`v2.15.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.15.0)

This release includes UI that will inform user when time-consuming migration needs to be run as part of IPFS node update:

![Screenshot 2022-02-25 at 17 51 21](https://user-images.githubusercontent.com/5447088/155754805-79c89a8d-87a9-456e-b43c-1fa3deb7fedd.png)

* feat: show repo migration (go-ipfs 0.12.0) by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/1982
* fix: remove default lower bound from gateway and api port lookup by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/1991
* chore: electron 17.1 and related deps by @lidel in https://github.com/ipfs/ipfs-desktop/pull/1998
* chore(i18n): locale sync bf2bfe54f48ccb0d5ec896a364b5d6eabe9b4155


**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.19.3...v0.20.0

## [v0.19.2] - 2021-02-14

* fix: macos autoupdate flow by @lidel in https://github.com/ipfs/ipfs-desktop/pull/1979

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.19.1...v0.19.2

## [v0.19.1] - 2021-02-14

- IPFS: [`go-ipfs v0.11.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.11.0)
- UI: [`v2.15.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.15.0)  ✨

Electron 17 and a bunch of bugfixes.
WebUI users may notice that it is now possible to set up [permanent peering with other nodes](https://github.com/ipfs/ipfs-webui/releases/v2.14.0):
> [![](https://user-images.githubusercontent.com/157609/152223529-ff7a2c47-3650-4a12-946f-9e4f44bb911c.png)](https://github.com/ipfs/ipfs-webui/releases/v2.14.0)

* feat: ipfs-webui v2.13 → v2.15.0
  - mostly bugfixes, but includes permanent peering support
  - see release notes for: [v2.14](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.14.0)+[v2.15](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.15.0)
* feat: electron 17 and playwright e2e tests by @hacdias and @lidel #1937
* feat: better handling of 'unresponsive' event by @hacdias in #1952
* fix: os-native add-to-ipfs on Windows and macOS  by @hacdias in https://github.com/ipfs/ipfs-desktop/pull/1976
* fix: dialog when IPFS_PATH/api port is offline by @lidel in 13de17403fcd1892a0830b3da0199d116a14d899
* fix: electron version  by @hacdias in #1965
* fix: add .manualCheckForUpdates before tray startup by @hacdias in #1950
* refactor: remove deprecated "ipfs on PATH" feature by @hacdias in  #1948
* chore: uninstall npm on ipfs  by @hacdias in #1947
* chore(i18n): locale sync by @lidel in 50c31bb8f09ea91b268b0a1c3189af105764025c
* chore: update dependencies by @lidel in  #1959, fa17bdd06ffaea0c0411d8f8a60d6d61e1afc5f7 and @hacdias  in #1899, #1960



**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.19.0...v0.19.1

## [v0.18.0] - 2021-12-13

This is the same as [0.18.0](https://github.com/ipfs/ipfs-desktop/releases/tag/v0.18.0), but with auto update fix for macOS.

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.18.0...v0.18.1

## [v0.18.0] - 2021-12-13

- IPFS: [`go-ipfs v0.11.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.11.0) ✨
- UI: [`v2.13.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.13.0)

* <del>fix: remove zip for Squirrel.Mac by @lidel in https://github.com/ipfs/ipfs-desktop/pull/1932</del> (reverted in 0.18.1)
* feat: go-ipfs 0.11.0 by @lidel in https://github.com/ipfs/ipfs-desktop/pull/1936
* chore: release prep by @lidel in https://github.com/ipfs/ipfs-desktop/pull/1938

**Full Changelog**: https://github.com/ipfs/ipfs-desktop/compare/v0.17.0...v0.18.0

## [v0.17.0] - 2021-10-05

- IPFS: [`go-ipfs v0.10.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.10.0)
- UI: [`v2.13.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.13.0)

* feat: go-ipfs 0.10.0 by @guseggert in https://github.com/ipfs/ipfs-desktop/pull/1896
* fix(ci): cache ipfs-webui by @lidel in https://github.com/ipfs/ipfs-desktop/pull/1913
* fix: analytics storage_path by @milahu in https://github.com/ipfs/ipfs-desktop/pull/1900
* chore: default `--agent-version-suffix` and `--routing` by @lidel in https://github.com/ipfs/ipfs-desktop/pull/1914
* chore: electron v13.5.1 and other deps by @lidel in https://github.com/ipfs/ipfs-desktop/pull/1915
* chore: switch to i18next-fs-backend by @lidel in https://github.com/ipfs/ipfs-desktop/pull/1916

## [v0.16.3] - 2021-09-08

- IPFS: [`go-ipfs v0.9.1`](https://github.com/ipfs/go-ipfs/releases/tag/v0.9.1)
- UI: [`v2.13.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.13.0)

### 🛠 Fixes and Maintenance

- feat: ipfs-webui v2.13.0 (#1903)
- feat: allow to show devtools (#1901)
- chore: update non-major dependencies (#1895)
- fix: use context bridge (#1894)
- docs: FreeBSD Linux Binary Compatibility (#1878)
- docs: debian 11 troubleshooting (b8044741aeb365f773f9c6f78dadbd26e1083963)
- chore: update maintainer AUR (#1880)
- chore(i18n):  locale sync

## [v0.16.2] - 2021-07-23

- IPFS: [`go-ipfs v0.9.1`](https://github.com/ipfs/go-ipfs/releases/tag/v0.9.1)
- UI: [`v2.12.4`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.12.4)

### 🛠 Fixes and Maintenance

- fix: go-ipfs 0.9.1 (#1876)
- chore: electron v13.1.7 (43da717df49812cbddd067e8521da42d849b8f6c)
- chore(i18n):  locale sync

## [v0.16.1] - 2021-07-06

- IPFS: [`go-ipfs v0.9.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.9.0)
- UI: [`v2.12.4`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.12.4)

### 🛠 Fixes and Maintenance

- fix: ipfs-webui v2.12.4 (#1868)
- fix: dont pin when adding to mfs (#1860)
- fix: show Files after import on windows (#1853)
- fix: choco publishing
- chore(i18n):  locale sync

## [v0.16.0] - 2021-06-23

- IPFS: [`go-ipfs v0.9.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.9.0)
- UI: [`v2.12.3`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.12.3)

### ✨ Features

- go-ipfs 0.9.0 ([RELEASE NOTES](https://github.com/ipfs/go-ipfs/releases/tag/v0.9.0))

### 🛠 Fixes and Maintenance

- electron 13.x (+ new electron-builder/updater)
- chore(i18n):  locale sync

## [v0.15.1] - 2021-06-17

- IPFS: [`go-ipfs v0.8.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.8.0)
- UI: [`v2.12.3`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.12.3)

### 🛠 Fixes and Maintenance

- fix: ipfs-webui  [`v2.12.3`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.12.3)
- fix: useful errors on download fail (#1843)
- chore(i18n): locale sync

## [v0.15.0] - 2021-05-04

- IPFS: [`go-ipfs v0.8.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.8.0)
- UI: [`v2.12.2`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.12.2)

### ✨ Features

- ipfs webui v2.12 with basic support for remote pinning (#1807)
  👉️ see [RELEASE NOTES for v2.12](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.12.0) for details
- electron 12.x (#1807)

### 🛠 Fixes and Maintenance

- fix: ipfs-on-path should never fail on boot (#1769)
- docs(readme): fix scoop install steps (#1808)
- docs: promote AppImage for Linux (#1776)
- chore: switch actions to v2 (#1708)
- chore(i18n): i18next update and locale sync


## [v0.14.0] - 2021-01-02

- IPFS: [`go-ipfs v0.8.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.8.0)
- UI: [`v2.11.4`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.11.4)

### ✨ Features

- go-ipfs 0.8.0 (#1715 +  [RELEASE NOTES](https://github.com/ipfs/go-ipfs/releases/tag/v0.8.0))
- electron 11.x (#1715)
- improve updating ux (#1758)
- enable ipns over pubsub via settings menu (#1739)
- disable/enable gc via settings menu (#1740)
- enable pubsub via settings menu (#1735)

### 🛠 Fixes and Maintenance

- fix: timeout during checkIfAddrIsDaemon (#1750)
- fix: default Open WebUI at Launch to true (#1757)
- fix: autoupdate only on supported platforms (#1698)
- fix:  specify content-type in prompt template (#1729)
- fix: use correct config path during development (#1690)
- fix(mac): refresh file list after import (#1767)
- refactor: tray click events (#1766)
- chore: deprecate ipfs-on-path (#1768) and npm-on-ipfs (17578745addb6c665b0c3a3e50499d3967c8efb5)
- docs: rework readme (#1703)
- chore: automated Chocolatey publishing (#1697)
- docs: Homebrew instructions (#1727)
- docs: brew cask has been deprecated (#1732)
- chore(i18n): locale sync (https://github.com/ipfs-shipyard/ipfs-desktop/commit/2f1631d2a1f83b98a2ef79bd2a8b37f9696b5a46)


## [v0.13.2] - 2020-10-12
- Web UI: [`v2.11.4`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.11.4)
- IPFS: [`go-ipfs v0.7.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.7.0)

### ✨ Features
- Use `dweb.link` gateway when shareable link is copied to clipboard
- Preserve filename when a single file is shared (screenshot, quick import)

### 🛠 Fixes and Maintenance
- fix: windows auto-update (#1679)
- feat(ci): automated Snapcraft publishing (#1678)
- fix: openItem errors (#1687)
- feat: screenshot improvements (#1689)
- fix: OS integrations for quick file import (#1691)
- fix(windows): autoInstallOnAppQuit (#1682)

#### :mega: Windows users may need to update manually

Below PRs fixed autoupdate issues on Windows platform, however older versions may still struggle to update.

-  fix: windows auto-update (#1679)
-  fix(windows): autoInstallOnAppQuit (#1682)

**If your node is unable to apply update to this version, please install [IPFS-Desktop-Setup-0.13.2.exe](https://github.com/ipfs-shipyard/ipfs-desktop/releases/download/v0.13.2/IPFS-Desktop-Setup-0.13.2.exe) manually.**
From now on, Windows updates should work as expected.

## [v0.13.1] - 2020-10-12
This release is exactly the same as [v0.13.2].
It exists so people can test Windows autoupdate fix on their own.

## [v0.13.0] - 2020-10-08
- Web UI: [`v2.11.4`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.11.4)
- IPFS: [`go-ipfs v0.7.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.7.0)

### ✨ Features
- webui v2.11.4 ([RELEASE NOTES](https://github.com/ipfs-shipyard/ipfs-webui/releases/tag/v2.11.4))
- go-ipfs v0.7.0 ([CHANGELOG](https://github.com/ipfs/go-ipfs/blob/master/CHANGELOG.md#v070-2020-09-22))
- synchronized and added new locales

### 🛠 Fixes and Maintenance
- electron 9 (#1641, 42b069b)
- fix: ensure small asar archive (#1660)
- fix: uppercase Discovery.MDNS.enabled in default config (#1632)
- ci: move to GitHub Actions (#1657)

### 📣 Windows updates may be delayed
Windows 10 users may need to wait a bit longer to see this release.
We are working on a fix.

## [v0.12.2] - 2020-07-17
- Web UI: [`v2.10.2`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.10.2)
- IPFS: [`go-ipfs v0.6.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.6.0)

### ✨ Features
- feat: ipfs-webui v2.10.2

## [v0.12.1] - 2020-07-07
- Web UI: [`v2.9.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.9.0)
- IPFS: [`go-ipfs v0.6.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.6.0)

### ✨ Features
- feat: ipfs-webui v2.9.0 (#1531)
- feat: go-ipfs 0.6 (#1526)

### 🛠 Fixes and Maintenance

- fix: windows auto-update feature when selecting install for all users (#1556)
## [v0.12.0] - 2020-07-06
- Web UI: [`v2.9.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.9.0)
- IPFS: [`go-ipfs v0.6.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.6.0)

### 🛠 Fixes and Maintenance

- feat: ipfs-webui v2.9.0 (#1531)
- feat: go-ipfs 0.6 (#1526)
- fix: windows auto-update feature when selecting install for all users (#1556)
## [v0.11.4] - 2020-05-21
- Web UI: [`v2.8.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.8.0)
- IPFS: [`go-ipfs v0.5.1`](https://github.com/ipfs/go-ipfs/releases/tag/v0.5.1)

### 🛠 Fixes and Maintenance

- chore: update dependencies
## [v0.11.3] - 2020-05-18
- IPFS: [`go-ipfs v0.5.1`](https://github.com/ipfs/go-ipfs/releases/tag/v0.5.1)

### 🛠 Fixes and Maintenance

- chore: update dependencies
## [v0.11.2] - 2020-04-30
- Web UI: [`v2.8.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.8.0) ✨
- IPFS: [`go-ipfs v0.5.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.5.0) ✨

### 🛠 Fixes and Maintenance

- fix: open directory from webui (https://github.com/ipfs-shipyard/ipfs-desktop/pull/1472)
## [v0.11.1] - 2020-04-29
- Web UI: [`v2.8.0`](https://github.com/ipfs-shipyard/ipfs-webui/releases/v2.8.0) ✨
- IPFS: [`go-ipfs v0.5.0`](https://github.com/ipfs/go-ipfs/releases/tag/v0.5.0) ✨

### 🚨 Breaking Changes

- fix: remove old auto launch method (#1416)
- fix: ipfs daemon flags (#1437)

### ✨  Features

- feat: support for go-ipfs 0.5 (#1392)
- feat: run garbage collector (#1407)
- feat: update ipfsd-ctl to 4.x (#1411)
- feat: improved update experience (#1414)
- feat(ux): improve download cid (#1419)
- feat(ux): improve gc (#1420)
- feat(ux): better error messages (#1421)
- feat(ux): separate open from other actions (#1424)
- feat(ux): move preferences to menubar (#1425)
- feat: allow custom ipfs binary (#1427)
- feat(ux): open web ui at login (#1429)
- feat: add "Help Translation" under "About" (#1447)
- feat: go-ipfs 0.5 (https://github.com/ipfs-shipyard/ipfs-desktop/pull/1463)

### 🛠 Fixes and Maintenance

- fix: drag&drop files and folders (https://github.com/ipfs-shipyard/ipfs-desktop/issues/1287#issuecomment-620604299)
- fix: start on login (#1334)
- fix: notify when new update is available (#1384)
- chore: update to electron 8.x (#1404)
- fix: write path when it does not exist (#1405)
- refactor: remove babel (#1406)
- fix: circular dependency between dialogs and daemon (#1408)
- fix: use portfinder instead of get-port (#1410)
- fix: screenshot taking (#1418)
- fix: disable updates in development (#1423)
- docs: clarify protocol usage (#1426)
- fix: translate 'Select Directory' (#1428)
- refactor: move utilities to utils directory (#1434)
- fix: repo fsck is deprecated (#1438)
- refactor: use store migrations and defaults (#1443)
- fix(ux): show dock when prompt is visible (#1450)
- fix: keep track of last opened page (#1452)
- fix: ipfs on PATH on windows with spaces in binary path #1465
- fix: go-ipfs 0.5.0 with go-ipfs-dep 0.5.0 #1464
- fix: macOS notarization with stappling (f01eb6b)
## [v0.11.0] - 2020-04-29
Skipped due to issues with macOS notarization.
Use [v0.11.1](https://github.com/ipfs-shipyard/ipfs-desktop/releases/tag/v0.11.1) instead.
## [v0.10.4] - 2020-03-12
- Web UI: [`v2.7.2`](https://github.com/ipfs-shipyard/ipfs-webui/releases/tag/v2.7.2)
- IPFS: [`go-ipfs v0.4.23`](https://github.com/ipfs/go-ipfs/releases/tag/v0.4.23)

### 🛠 Fixes and Maintenance

- i18n: sync locales (#1347)
- chore: macOS notarizing scripts and proces (#1365)
- fix: startup on Debian 10 (#1370)
## [v0.10.3] - 2020-02-04
- Web UI: [`v2.7.2`](https://github.com/ipfs-shipyard/ipfs-webui/releases/tag/v2.7.2)
- IPFS: [`go-ipfs v0.4.23`](https://github.com/ipfs/go-ipfs/releases/tag/v0.4.23)

### ✨  Features

- I18N: `ja-JP`, `he-IL` and `hi-IN` locales (#1339)

### 🛠 Fixes and Maintenance

- fix: start with off icon (#1300)
- chore: dependency updates (#1341)
