---
title: About This Site
customFields: 
  -
    key: "is_chapter"
    value: 0
---

Learning how and when to use jQuery is a different process for each and every
web developer, depending largely on experience with the primary tools for
front-end development (HTML, CSS, and JavaScript) and knowledge of general
programming principles. Over the years developers of all stripes have come to
rely on our [API documentation](http://api.jquery.com) for help figuring out
how to do exactly what they need to do.

However, API documentation alone cannot serve as a guide to solving problems
and fostering a true understanding of web development. Over the years, an
ecosystem of blog posts, books, support forums and channels has grown to help
cover the **hows** and **whys** of developing with jQuery, as well as explaining
best practices, techniques, and workarounds for common problems. This type of
documentation has been invaluable resource for millions of people, but the
experience of navigating these waters can be frustrating as often as it is
fulfilling, as developers struggle to identify trustworthy resources, determine
whether what they're reading is actually up to date, and figure out those
magical search keywords that are _just right_!

This site represents the jQuery Foundation's ongoing effort to consolidate and
curate this information in order to provide this crucial "narrative
documentation" to our community and serve the following goals:

1. Provide our **users** with a digestible reference on all aspects of using jQuery, from the basics of getting started and performing common tasks to more advanced topics like approaches to structuring code and where jQuery fits into modern web application development.
2. Provide our **contributors** a central, open place to collaborate and provide a dependable, highly sharable resource that will improve our users' support experiences
3. Foster an environment by which users are encouraged to become contributors and build the skills to help them work on jQuery -- or any other open source project!

In order to achieve these goals, all of [this site's content is maintained
publicly on GitHub](http://github.com/jquery/learn.jquery.com) and is licensed
under the [MIT
License](https://github.com/jquery/learn.jquery.com/blob/master/MIT-LICENSE.txt).
To learn more about how the site works, take a look at our [contributing
guide](/contributing).

## History

The jQuery Learning site has its roots in two primary places.

The first is Rebecca Murphey's [jQuery Fundamentals](http://jqfundamentals.com/legacy),
a free, open source book on jQuery basics she originally released in 2010.
Seeking a better home where the information could be both maintained going
forward, and consumed in a more piecemeal fashion, Rebecca donated the content
to the jQuery Foundation to form the basis of what was then an abstract idea
for some sort of "learning center."

The second is [docs.jquery.com](http://docs.jquery.com), that erstwhile
chestnut still living out its final days before it will be shut down in early
2013. Since we've moved the API documentation for jQuery Core off that domain,
we needed a place that could serve a similar need -- documentation (that anyone
can contribute to) that gets into the "how-to" and FAQs -- without clumsy
barriers to entry like finding the right person to set you up with a special
wiki account and forcing all authoring into a `textarea`.

<h2><a name="beta">About the Beta</a></h2> 

Though this resource will never truly be "done," the current version of this
site should still be considered something of a preview. We still have a number
of improvements we want to make to the content, user experience, and site build
before we're ready to call it a "final release." At the same time, however,
it's important for us to open the doors now so we can begin providing better
docs to people who need the right away and spread the word about this effort.
If you're interested in helping us reach the finish line, we invite you to
please read more about how [you can get involved with contributing](/contributing)!
