---
title: Using jQuery UI ThemeRoller
level: beginner
---
![ThemeRoller logo](/resources/jquery-ui/themeroller-logo.png)

### About ThemeRoller
ThemeRoller is a web app that offers a fun and intuitive interface for designing and downloading custom themes for jQuery UI. You can find ThemeRoller in the "Themes" section of the jQuery UI site, or by following this link: [jQuery UI ThemeRoller](http://jqueryui.com/themeroller)

![ThemeRoller Sidebar](/resources/jquery-ui/themeroller_interface_new.png)
![ThemeRoller Sidebar](/resources/jquery-ui/themeroller_gallery_new.png)

### The ThemeRoller Interface
The interface for ThemeRoller is categorized into panels for global font and corner radius settings, widget container styles, and interaction states for clickable elements, and various styles for overlays and shadows. These panels allow configuration of various CSS properties such as font size, color, and weight, background color and texture, border color, text color, icon color, corner radius, and more!

### The Theme Gallery: Pre-Rolled Themes
ThemeRoller themes can be viewed via permalink URLs, and it includes a gallery of pre-designed themes to choose from. The theme gallery is accessible through the tab strip located at the top of the application interface. From the gallery, you can preview and download themes, or even choose to tweak a theme further in the "Roll Your Own" tab.

### Downloading Themes
When you're done designing a theme, you can download it for use in your projects. ThemeRoller has a "Download Theme" button at the top which will generate a ZIP file containing all of theme assets. Images included in your download will be generated to your specifications and saved as high-quality PNG files. 

Your theme will include images and CSS that make up a customized version of the jQuery UI CSS Framework including images and CSS for all of our plugins.

### Installing downloaded themes into your project
Once the theme has been downloaded and unzipped, you will see a folder named `themes`. This folder contains the CSS and images needed for your theme. Copy the theme directory into your project and link to the `themes/all.css` file from your pages.

### Building Custom "ThemeRoller-Ready" Components
![ThemeRoller Ready Banner](/resources/jquery-ui/Themeroller_ready_black_200px.png)
![ThemeRoller Ready Banner](/resources/jquery-ui/Themeroller_ready_white_200px.png)

ThemeRoller generates a customized version of the jQuery UI CSS Framework for developing your own ThemeRoller-Ready jQuery components. The classes generated by this framework are designed to accommodate common user interface design situations and include states, icons, and various helper classes as well.

For information on developing with the jQuery UI CSS Framework, visit our [Theming API documentation](/jquery-ui/theming/api).

### ThemeRoller Links
* [Tutorial: Develop Your Own jQuery “ThemeRoller-Ready” Components, Filament Group](http://www.filamentgroup.com/lab/developer_your_own_jquery_themeroller_ready_components/)
* [Introducing ThemeRoller: Design & Download Custom Themes for jQuery UI, Filament Group](http://www.filamentgroup.com/lab/introducing_themeroller_design_download_custom_themes_for_jquery_ui/)
* [Videos about Design & Download Custom Themes for jQuery UI, Filament Group](http://www.dizi-izle-film-izle.net)

### Credits
ThemeRoller was designed and developed for jQuery UI by [Filament Group, Inc](http://www.filamentgroup.com), of Boston, MA.
