package CTSMS::BulkProcessor::RestRequests::ctsms::shared::SelectionSetService::CourseParticipationStatusType;
use strict;

## no critic

use CTSMS::BulkProcessor::ConnectorPool qw(
    get_ctsms_restapi

);

use CTSMS::BulkProcessor::RestProcessor qw(
    copy_row
    get_query_string
);

use CTSMS::BulkProcessor::RestConnectors::CtsmsRestApi qw(_get_api);
use CTSMS::BulkProcessor::RestItem qw();

use CTSMS::BulkProcessor::Utils qw(booltostring);

require Exporter;
our @ISA = qw(Exporter CTSMS::BulkProcessor::RestItem);
our @EXPORT_OK = qw(
    get_item
    get_item_path

    get_initial_items
    get_transition_items
);

my $default_restapi = \&get_ctsms_restapi;
my $get_item_path_query = sub {
    my ($id) = @_;
    return 'selectionset/courseparticipationstatustype/' . get_query_string({ typeId => $id });
};
my $get_initial_items_path_query = sub {
    my ($admin,$selfregistration) = @_;
    return 'selectionset/initialcourseparticipationstatustypes/' . get_query_string({ admin => booltostring($admin), selfRegistration => booltostring($selfregistration) });
};
my $get_transition_items_path_query = sub {
    my ($id,$admin,$selfregistration) = @_;
    return 'selectionset/courseparticipationstatustypetransitions/' . get_query_string({ admin => booltostring($admin), selfRegistration => booltostring($selfregistration), typeId => $id });
};


my $fieldnames = [
    "acknowledge",
    "adminInitial",
    "adminSelfRegistrationInitial",
    "cancel",
    "color",
    "id",
    "name",
    "nameL10nKey",
    "notify",
    "pass",
    "relevantForCourseAppointments",
    "userInitial",
    "userSelfRegistrationInitial",
];

sub new {

    my $class = shift;
    my $self = CTSMS::BulkProcessor::RestItem->new($class,$fieldnames);

    copy_row($self,shift,$fieldnames);

    return $self;

}

sub get_item {

    my ($id,$load_recursive,$restapi,$headers) = @_;
    my $api = _get_api($restapi,$default_restapi);
    return builditems_fromrows($api->get(&$get_item_path_query($id),$headers),$load_recursive,$restapi);

}

sub get_initial_items {

    my ($admin,$selfregistration,$load_recursive,$restapi,$headers) = @_;
    my $api = _get_api($restapi,$default_restapi);
    return builditems_fromrows($api->get(&$get_initial_items_path_query($admin,$selfregistration),$headers),$load_recursive,$restapi);

}

sub get_transition_items {

    my ($id,$admin,$selfregistration,$load_recursive,$restapi,$headers) = @_;
    my $api = _get_api($restapi,$default_restapi);
    return builditems_fromrows($api->get(&$get_transition_items_path_query($id,$admin,$selfregistration),$headers),$load_recursive,$restapi);

}










sub builditems_fromrows {

    my ($rows,$load_recursive,$restapi) = @_;

    my $item;

    if (defined $rows and ref $rows eq 'ARRAY') {
        my @items = ();
        foreach my $row (@$rows) {
            $item = __PACKAGE__->new($row);

            # transformations go here ...

            push @items,$item;
        }
        return \@items;
    } elsif (defined $rows and ref $rows eq 'HASH') {
        $item = __PACKAGE__->new($rows);
        return $item;
    }
    return undef;

}

sub get_item_path {

    my ($id) = @_;
    return &$get_item_path_query($id);

}

1;
