package CTSMS::BulkProcessor::RestRequests::ctsms::shared::SelectionSetService::ProbandCategory;
use strict;

## no critic

use CTSMS::BulkProcessor::ConnectorPool qw(
    get_ctsms_restapi

);

use CTSMS::BulkProcessor::RestProcessor qw(
    copy_row
    get_query_string
);

use CTSMS::BulkProcessor::RestConnectors::CtsmsRestApi qw(_get_api);
use CTSMS::BulkProcessor::RestItem qw();

use CTSMS::BulkProcessor::Utils qw(booltostring);

require Exporter;
our @ISA = qw(Exporter CTSMS::BulkProcessor::RestItem);
our @EXPORT_OK = qw(
    get_item
    get_item_path

    get_preset_item
    get_all
    get_items
);

my $default_restapi = \&get_ctsms_restapi;
my $get_item_path_query = sub {
    my ($id) = @_;
    return 'selectionset/probandcategory/' . get_query_string({ categoryId => $id });
};
my $get_preset_item_path_query = sub {
    my ($signup,$person) = @_;
    return 'selectionset/probandcategorypreset/' . get_query_string({ signup => booltostring($signup), person => booltostring($person), });
};
my $get_all_path_query = sub {
    return 'selectionset/allprobandcategories/';
};
my $get_items_path_query = sub {
    my ($person,$animal) = @_;
    my %params = ();
    $params{person} = booltostring($person) if defined $person;
    $params{animal} = booltostring($animal) if defined $animal;
    return 'selectionset/probandcategories/' . get_query_string(\%params);
};

my $fieldnames = [
    "color",
    "id",
    "locked",
    "name",
    "nameL10nKey",
    "nodeStyleClass",
    "preset",
    "signup",
    "privacyConsentControl",
    "person",
    "animal",
];

sub new {

    my $class = shift;
    my $self = CTSMS::BulkProcessor::RestItem->new($class,$fieldnames);

    copy_row($self,shift,$fieldnames);

    return $self;

}

sub get_item {

    my ($id,$load_recursive,$restapi,$headers) = @_;
    my $api = _get_api($restapi,$default_restapi);
    return builditems_fromrows($api->get(&$get_item_path_query($id),$headers),$load_recursive,$restapi);

}

sub get_items {

    my ($person,$animal,$load_recursive,$restapi,$headers) = @_;
    my $api = _get_api($restapi,$default_restapi);
    return builditems_fromrows($api->get(&$get_items_path_query($person,$animal),$headers),$load_recursive,$restapi);

}

sub get_preset_item {

    my ($signup,$person,$load_recursive,$restapi,$headers) = @_;
    my $api = _get_api($restapi,$default_restapi);
    return builditems_fromrows($api->get(&$get_preset_item_path_query($signup,$person),$headers),$load_recursive,$restapi);

}

sub get_all {
    my ($load_recursive,$restapi,$headers) = @_;
    my $api = _get_api($restapi,$default_restapi);
    return builditems_fromrows($api->get(&$get_all_path_query(),$headers),$load_recursive,$restapi);
}

sub builditems_fromrows {

    my ($rows,$load_recursive,$restapi) = @_;

    my $item;

    if (defined $rows and ref $rows eq 'ARRAY') {
        my @items = ();
        foreach my $row (@$rows) {
            $item = __PACKAGE__->new($row);

            # transformations go here ...

            push @items,$item;
        }
        return \@items;
    } elsif (defined $rows and ref $rows eq 'HASH') {
        $item = __PACKAGE__->new($rows);
        return $item;
    }
    return undef;

}

sub get_item_path {

    my ($id) = @_;
    return &$get_item_path_query($id);

}

1;
