\set citizens	100000
-- Switch off AQO
SET aqo.mode = 'disabled';
SET aqo.show_details = 'off';

-- Clear the tables, if needed.
TRUNCATE person,employees,disabled,aqo_data CASCADE;

-- Fill the person table with workers data.
INSERT INTO person (id,age,gender,passport)
	(SELECT q1.id,q1.age,
	 		CASE WHEN random()<0.25 THEN 'Female' ELSE 'Male' END,
	 		CASE WHEN (q1.age>18) THEN 1e5+random()*(1e6-1e5)::integer ELSE NULL END
	 FROM (SELECT *, prandom(20)+14 AS age FROM generate_series(1, :citizens) id) AS q1
	);

-- Add first company
INSERT INTO employees (cid,id,position)
	(SELECT random()*300::integer, *,
	 		CASE WHEN ceil(random()*5)=1 THEN 'Manager'
	 			 WHEN ceil(random()*5)=2 THEN 'Helper'
	 			 WHEN ceil(random()*5)=3 THEN 'Dispatcher'
	 			 WHEN ceil(random()*5)=4 THEN 'Tractor driver'
	 			 ELSE 'Truck driver'
	 		END
	 FROM generate_series(1,:citizens/10));


INSERT INTO disabled (person_id)
	(SELECT random() * :citizens FROM generate_series(1, :citizens * 0.01));

-- Refresh statistics
ANALYZE person,employees;

-- Try to see a number of unemployed
EXPLAIN (ANALYZE,TIMING OFF,BUFFERS OFF)
SELECT count(*) FROM (
	SELECT id,age,cid AS companyID
	FROM person
	LEFT JOIN employees USING (id)
) AS q1 WHERE q1.companyID IS NULL;

-- Try to use this poorly-estimated query in another JOIN,
-- called 'See unemployed disabled people'
EXPLAIN (ANALYZE,TIMING OFF,BUFFERS OFF)
SELECT * FROM disabled JOIN (
SELECT id,age FROM (
	SELECT id,age,cid AS companyID
	FROM person
	LEFT JOIN employees USING (id)
) AS q1 WHERE q1.companyID IS NULL
) AS q2 ON person_id=id;

SET aqo.mode = 'intelligent';
SET aqo.show_details = 'on';
TRUNCATE aqo_queries CASCADE;

DO
$do$
DECLARE
	i integer;
	r text;
BEGIN
	FOR i IN 1..5 LOOP
		EXPLAIN (ANALYZE,TIMING OFF,BUFFERS OFF)
		SELECT * FROM disabled JOIN (
			SELECT id,age FROM (
				SELECT id,age,cid AS companyID
				FROM person
				LEFT JOIN employees USING (id)
			) AS q1 WHERE q1.companyID IS NULL
		) AS q2 ON person_id=id INTO r;
		raise NOTICE '-- %',r;

	END LOOP;
END;
$do$;
