import org.jetbrains.kotlin.gradle.tasks.KotlinCompile

plugins {
    kotlin("jvm") version "1.9.20"
    kotlin("plugin.serialization") version "1.9.20"
    alias(libs.plugins.quarkus)
}

kotlin {
    jvmToolchain {
        languageVersion = JavaLanguageVersion.of(21)
    }
}

repositories {
    mavenCentral()
}

dependencyLocking {
    lockAllConfigurations()
}

dependencies {
    implementation(enforcedPlatform(libs.quarkus.bom.core))
    implementation(enforcedPlatform(libs.quarkus.bom.operator))
    implementation(libs.arrow.coroutines)
    implementation(libs.jackson.module.kotlin)
    implementation(libs.kotlin.logging)
    implementation(libs.quarkus.arc)
    implementation(libs.quarkus.kotlin)
    implementation(libs.quarkus.operatorsdk)

    testImplementation(enforcedPlatform(libs.quarkus.bom.core))
    testImplementation(libs.archunit)
    testImplementation(libs.jimfs)
    testImplementation(libs.kotest.arrow)
    testImplementation(libs.kotest.assertions)
    testImplementation(libs.kotest.json)
    testImplementation(libs.kotest.runner)
}

tasks {
    test {
        useJUnitPlatform()
    }

    withType(KotlinCompile::class) {
        kotlinOptions.freeCompilerArgs = listOf("-Xcontext-receivers")
    }
}
