package com.example.operator

import io.fabric8.kubernetes.api.model.Condition
import java.time.Instant
import java.time.temporal.ChronoUnit

interface ConditionAware {
    val conditions: MutableList<Condition>

    fun add(condition: Condition): Boolean {
        var changed = false
        val find = conditions.firstOrNull { it.type == condition.type }

        return if (find == null) {
            conditions.add(condition)
            true
        } else {
            if (find.status != condition.status) {
                find.status = condition.status
                find.lastTransitionTime = Instant.now().truncatedTo(ChronoUnit.SECONDS).toString()
                changed = true
            }
            if (find.reason != condition.reason) {
                find.reason = condition.reason
                changed = true
            }
            if (find.message != condition.message) {
                find.message = condition.message
                changed = true
            }
            if (find.observedGeneration != condition.observedGeneration) {
                find.observedGeneration = condition.observedGeneration
                changed = true
            }
            changed
        }
    }
}
