package com.example.operator

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.module.kotlin.KotlinModule
import io.quarkus.kubernetes.client.KubernetesClientObjectMapperCustomizer
import jakarta.enterprise.context.ApplicationScoped

@ApplicationScoped
class ObjectMapperCustomizer : KubernetesClientObjectMapperCustomizer {
    override fun customize(objectMapper: ObjectMapper) {
        val kotlinModule = KotlinModule.Builder().build()
        objectMapper.registerModule(kotlinModule)
    }
}
