package com.example.operator.frontend.crd

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.fabric8.kubernetes.api.model.EnvVar

@JsonIgnoreProperties(ignoreUnknown = true)
data class PlatformFrontendSpec(
    val project: String,
    val name: String,
    val environment: String,
    val version: String,
    val image: Image,
    val ingress: Ingress? = null,
    val env: List<EnvVar> = listOf(),
)

@JsonIgnoreProperties(ignoreUnknown = true) class Image(val registry: String)

@JsonIgnoreProperties(ignoreUnknown = true) class Ingress(val domain: String? = null)
